package de.javamagazin.myblog

class BlogComment {
  
  String  message
  Date  dateCreated
  
  BlogUser      user
  static belongsTo = [article:BlogArticle]
  
  static constraints = {
    message    (blank:false, nullable:false, size:5..1000)
    user       (nullable:true)               // anonymous comments are ok
  } 
  
  String toString() {
    return "#${id}: ${message?.size()<21?message:message[0..19]}"   
  }  

}
