package de.javamagazin.myblog

class BlogUser {

  String  username
  String  password
  String  email
  
  static hasMany = [comments:BlogComment,
                    articles:BlogArticle]
                    
  static constraints = {
    username    (blank:false, nullable:false, size:3..30, unique:true, matches:"[a-zA-Z]+")
    password    (blank:false, nullable:false, size:3..30)
    email       (email:true)        
  } 
  
  
  String toString() {
    return "#${id}: ${username}"   
  }                  

}
