<html>
    <head>
        <meta name="layout" content="site">
        <title>Willkommen bei MyBlog</title>
    </head>
    
    <body>
        <g:each var="article" in="${blogArticles}">
            <div class="post">
                <h2 class="title">${article.subject}</h2>
                <p class="meta"><em>
                    { Veröffentlicht von ${article.author.username} 
                    am  <g:formatDate format="dd.MM.yy" date="${article.dateCreated}"/>}
                </em></p>
                <div class="entry">
                    <p>${article.body}</p>
                    <div id="comment_area_${article.id}">
                        <g:render template="comments" model="[article:article]" />
                    </div>
                </div>
            </div>
        </g:each>
        <div class="paginateButtons">
            <g:paginate total="${blogCount}" />
        </div>
    </body>

    <content tag="sidebar">
        <li> 
            <h2>Dies ist unsere Sidebar</h2>
            <p>Hier stehen später seitenspezfische Informationen oder Aktionen,
            wie z.B. die 
            <g:link controller="home" action="index" params="[color:'green']"> Seite färben.</g:link>
            
            </p>
        </li>
        <my:showAdvertising />
    </content>    
    
</html>
