package de.javamagazin.myblog

import org.jsecurity.SecurityUtils

/**
 * Main controller handling the user's view of MyBlog
 */ 
class HomeController {

    /**
     *  Default action, responsible for building the blog list view
     */         
    def index = { 
        log.debug ('Page of MyBlog is requested!')
        Map model = [:]
        model.blogArticles = BlogArticle.findAllByStatus ( ArticleStatus.PUBLISHED, 
                                                          [max:10,
                                                           offset:params.offset,
                                                           sort:'dateCreated',
                                                           order:'desc'] )
        model.blogCount = BlogArticle.countByStatus ( ArticleStatus.PUBLISHED)                                                           
        return model
    }
    
    /**
     *  Delegates the Ajax-Rendering of comments
     */         
    def ajaxShowComments = {
        def ba = BlogArticle.read(params.id)
        render (template:'comments', model:[article:ba,showComments:true])
    }
    
    
    /**
     *   Save a new comment and returns html-fragment for ajax-request
     */         
    def ajaxSaveComment = {
        log.info ("User is saving a comment!")
        Map model = [:]
        BlogArticle article = BlogArticle.read(params.articleId) 
        BlogComment comment = new BlogComment()
        comment.message = params.message
        comment.article = article
        if (SecurityUtils.subject.isAuthenticated()) {
            comment.user = BlogUser.findByUsername(SecurityUtils.subject.principal) 
        }
        if (!comment.save()) {
            model.newComment = comment
            model.showComments=true    // show formular again on error
        }
        model.article = article
        render (template:'comments', model:model)
    }
}
