package de.javamagazin.myblog

import grails.test.*
import org.jsecurity.*
import org.jsecurity.subject.*

class HomeControllerTests extends ControllerUnitTestCase {

    HomeController controller
    def securityMock
    def comments = []                  
   
    protected void setUp() {
        super.setUp()
        // mock article domain objects
        def blogArticle =  [ new BlogArticle(id:11, subject:'Wir testen...') ]
        mockDomain (BlogArticle, blogArticle)
        // mock comment domain objects
        mockDomain (BlogComment,comments)
        // mock security object
        securityMock = mockFor(SecurityUtils) 
        securityMock.demand.static.getSubject(1..2) {-> [isAuthenticated:{false}] as Subject}
        // init object under test
        controller = new HomeController()
    }
    
    void testAjaxSaveCommentSuccessful() {
        mockParams.articleId = 11
        mockParams.message = 'Mein Kommentar zum Blog'
        controller.ajaxSaveComment()
        assertNotNull renderArgs.model.article
        assertNull "Comment shouldn't be in model!", renderArgs.model.newComment
        assertEquals 1, comments.size()
        assertEquals 'Mein Kommentar zum Blog', comments[0].message
        securityMock.verify()
    }
    
    void testAjaxSaveCommentFailed() {
        mockParams.articleId = 11
        mockParams.message = 'x'
        controller.ajaxSaveComment()
        assertNotNull "Failed Comment must be in model!", renderArgs.model.newComment
        assertTrue renderArgs.model.showComments
        assertTrue renderArgs.model.newComment.hasErrors()
        assertEquals 0, comments.size()    
    }
    
}
