// locations to search for config files that get merged into the main config
// config files can either be Java properties files or ConfigSlurper scripts

// grails.config.locations = [ "classpath:${appName}-config.properties",
//                             "classpath:${appName}-config.groovy",
//                             "file:${userHome}/.grails/${appName}-config.properties",
//                             "file:${userHome}/.grails/${appName}-config.groovy"]

// if(System.properties["${appName}.config.location"]) {
//    grails.config.locations << "file:" + System.properties["${appName}.config.location"]
// }
grails.mime.file.extensions = true // enables the parsing of file extensions from URLs into the request format
grails.mime.use.accept.header = false
grails.mime.types = [ html: ['text/html','application/xhtml+xml'],
                      xml: ['text/xml', 'application/xml'],
                      text: 'text/plain',
                      js: 'text/javascript',
                      rss: 'application/rss+xml',
                      atom: 'application/atom+xml',
                      css: 'text/css',
                      csv: 'text/csv',
                      all: '*/*',
                      json: ['application/json','text/json'],
                      form: 'application/x-www-form-urlencoded',
                      multipartForm: 'multipart/form-data'
                    ]
// The default codec used to encode data with ${}
grails.views.default.codec="none" // none, html, base64
grails.views.gsp.encoding="UTF-8"
grails.converters.encoding="UTF-8"

// enabled native2ascii conversion of i18n properties files
grails.enable.native2ascii = true


// log4j configuration

log4j = {
    error  'org.codehaus.groovy.grails'             // show grails errors
    warn   'org.mortbay.log'                        // show jetty warning
    debug  'grails.app'
           'de.javamagazin.myblog'
}

loggingProduction = {
    def myAppender = new org.apache.log4j.DailyRollingFileAppender(
                      name:'file',
                      file:'/log/myblog.log',
                      datePattern:"'.'yyyy-MM-dd",
                      layout: pattern(conversionPattern: '[%d{HH:mm:ss.SSS}] [%5p] [%t] [%c] %m%n')
                    )
    appenders {
        appender myAppender
    }
    root {
        error 'file'
    }
    info  'grails.app'
          'de.javamagazin.myblog'
}


environments {
    development {
        // default logging 
    }
    test { 
        // default logging
    }
    production {
        log4j = loggingProduction
    }
}





     