package de.javamagazin.myblog

class BlogArticle {
  
  // properties
  String        subject
  String        body
  ArticleStatus status = ArticleStatus.UNPUBLISHED
  Date          dateCreated
  Date          lastUpdated
  
  // relations
  BlogUser      author
  static hasMany = [comments:BlogComment]
  
  // properties constraints
  static constraints = {
    subject (blank:false, nullable:false, size:5..200, unique:true)
    body    (blank:false, nullable:false, size:5..10000)
    status  (nullable:false)
    author  (nullable:false)
  } 
  
  // overwrite toString()
  String toString() {
    return "#${id}: ${subject?.size()<21?subject:subject[0..19]}"   
  }  

}


enum ArticleStatus {
  UNPUBLISHED,
  PUBLISHED,
  DISABLED
}
