class BlogFunctionalTests extends functionaltestplugin.FunctionalTestCase {
    
    void testPaging() {
        // check the first page
        get ('/')
        assertStatus 200
        assertContentContains '<h1>MyBlog</h1>'
        def nodesFirst = page.getByXPath("//div[@class='post']")
        assertEquals 10, nodesFirst?.size()
        // check the second page
        click ('Naechste')
        assertStatus 200
        def nodesSecond = page.getByXPath("//div[@class='post']")
        assertTrue nodesSecond?.size() > 3
        assertContentContains  'class="prevLink"'
        // articles from first page shouldn't be on the second page
        def titleSecond = nodesSecond*.firstChild*.asText()
        for (node in nodesFirst) {
            def title = node.firstChild.asText()
            assertTrue ("${title} shouldn't be in ${titleSecond}", !titleSecond.contains(title))  
        }
    }
    
    void testBackofficeLogin() {
        get ('/backoffice')
        assertContentContains '<form action="/blogapp/auth/signIn"'
        form ('login') {
            username = 'admin'
            password = 'geheim'
            click 'submit'   
        }
        assertContentContains 'Backoffice von <a href="/blogapp/">MyBlog</a>'
    }
    
}
