package de.javamagazin.myblog

import grails.test.*

class HomeControllerIntegrationTests extends ControllerUnitTestCase {

    def controller
    def sessionFactory

    protected void setUp() {
        super.setUp()
        //  check pre-condition   (bootstrap-data)
        assertTrue BlogArticle.count()>20
        def countPublished = BlogArticle.countByStatus ( ArticleStatus.PUBLISHED)
        assertTrue countPublished > 10
        assertTrue countPublished < BlogArticle.count()
        //  init object under test (OUT)
        controller = new HomeController()
        
    }

    void testIndexSorting() {
        // prepare test-data: shuffle the creationDate 
        def dayDelta = 2.0
        BlogArticle.list().each {
            dayDelta = -dayDelta * 1.2
            it.dateCreated = new Date() + (int)dayDelta
            it.save()
        }
        sessionFactory.currentSession.flush()
        // call first page
        Map model = controller.index()
        List articles = model.blogArticles
        assertEquals 10, articles?.size()
        (1..articles.size()-1).each {
            assertTrue articles[it-1].dateCreated >= articles[it].dateCreated
        }
        // call second page
        mockParams.offset = 10
        model = controller.index()
        List nextArticles = model.blogArticles
        assertTrue nextArticles[0].dateCreated <= articles[-1].dateCreated
        (1..nextArticles.size()-1).each {
            assertTrue nextArticles[it-1].dateCreated >= nextArticles[it].dateCreated
        } 
    }
    
    
    void testIndexPublished() {
        // prepare test-data: set all entries to unpublished 
        BlogArticle.list().eachWithIndex { a, i ->
            a.status = i%2 ? ArticleStatus.DISABLED : ArticleStatus.UNPUBLISHED
            a.save()
        }
        sessionFactory.currentSession.flush()
        // check result
        Map model = controller.index()
        List articles = model.blogArticles
        assertEquals 0, model.blogArticles.size()
        assertEquals 0, model.blogCount
    }
    
}
